function [peak_pos, kpeak, vel, g0peak] = get_peak_pos(kinterp, ...
    g0interp, tri, scat, energy)

beta1 = kinterp.horz*tri.L*tri.amech;
beta2 = kinterp.slant*tri.L*tri.amech;
beta3 = beta2;

% Quadratic equation of the form: x^2+ax+1=0
a = 1/(abs(scat.t1)^4*abs(scat.t2)^2)*exp(-1i*(beta1+beta2+beta3)).*...
    (-exp(2i*beta3).*scat.t1.*scat.t2.*(-conj(scat.r1).*(exp(2i*beta2).*scat.t1.*conj(scat.r1)+...
    conj(scat.r2).*conj(scat.t1))+exp(2i*beta1).*(exp(2i*beta2).*scat.t1+scat.r1.*conj(scat.r2).*conj(scat.t1)...
    ))+conj(scat.t1).*conj(scat.t2).*(exp(2i*(beta1+beta2)).*scat.r1.*scat.r2.*scat.t1-exp(2i*beta2).*scat.r2.*scat.t1.*...
    conj(scat.r1)+(-1+exp(2i*beta1).*scat.r1^2).*conj(scat.t1)));

% Peak positions
[peak_pos, kpeak, vel, g0peak] = find_roots(energy, real(a)+2, ...
    kinterp, g0interp);

end